/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.iforce2d.Jb2dJson;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.RevoluteJoint;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class LoadRUBE_walker
extends TestbedTest {
    Joint[] walkerJoints = null;
    int driveState = 0;

    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }

    @Override
    public void initTest(boolean argDeserialized) {
        if (argDeserialized) {
            return;
        }
        Jb2dJson json = new Jb2dJson();
        StringBuilder errorMsg = new StringBuilder();
        World world = json.readFromFile("walker.json", errorMsg);
        if (null != world) {
            this.m_world = world;
            this.groundBody = this.m_world.createBody(new BodyDef());
            this.m_world.setDestructionListener(this.destructionListener);
            this.m_world.setContactListener(this);
            this.m_world.setDebugDraw(this.model.getDebugDraw());
            this.walkerJoints = json.getJointsByName("walkerjoint");
        } else {
            System.out.println(errorMsg);
        }
    }

    void updateDriveState() {
        if (this.walkerJoints.length == 0) {
            return;
        }
        float maxSpeed = 5.0f;
        float desiredSpeed = 0.0f;
        if (this.driveState == 1) {
            desiredSpeed = -maxSpeed;
        } else if (this.driveState == 2) {
            desiredSpeed = maxSpeed;
        }
        for (int i = 0; i < this.walkerJoints.length; ++i) {
            ((RevoluteJoint)this.walkerJoints[i]).setMotorSpeed(desiredSpeed);
        }
    }

    @Override
    public void keyPressed(char key, int argKeyCode) {
        switch (key) {
            case 'j': {
                this.driveState |= 1;
                break;
            }
            case 'k': {
                this.driveState |= 2;
            }
        }
        this.updateDriveState();
    }

    @Override
    public void keyReleased(char key, int argKeyCode) {
        switch (key) {
            case 'j': {
                this.driveState &= 0xFFFFFFFE;
                break;
            }
            case 'k': {
                this.driveState &= 0xFFFFFFFD;
            }
        }
        this.updateDriveState();
    }

    @Override
    public Vec2 getDefaultCameraPos() {
        return new Vec2(200.0f, 0.0f);
    }

    @Override
    public void step(TestbedSettings settings) {
        super.step(settings);
        this.addTextLine("Press j/k to drive");
    }

    @Override
    public String getTestName() {
        return "Load RUBE - walker";
    }
}

