/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import java.util.ArrayList;
import java.util.Arrays;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.MassData;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class LiquidTest
extends TestbedTest {
    private boolean firstTime = true;
    private int nParticles = 1000;
    private float totalMass = 10.0f;
    private float boxWidth = 2.0f;
    private float boxHeight = 20.0f;
    private float fluidMinX = -11.0f;
    private float fluidMaxX = 5.0f;
    private float fluidMinY = -10.0f;
    private float fluidMaxY = 10.0f;
    private Body[] liquid;
    private float rad = 0.6f;
    private float visc = 0.004f;
    private ArrayList<Integer>[][] hash = new ArrayList[40][40];
    private int hashWidth;
    private int hashHeight;
    public static Integer LIQUID_INT = new Integer(1234598372);
    private Body bod;

    private int hashX(float x) {
        float f = MathUtils.map(x, this.fluidMinX, this.fluidMaxX, 0.0f, (float)this.hashWidth - 0.001f);
        return (int)f;
    }

    private int hashY(float y) {
        float f = MathUtils.map(y, this.fluidMinY, this.fluidMaxY, 0.0f, (float)this.hashHeight - 0.001f);
        return (int)f;
    }

    public LiquidTest() {
        for (int i = 0; i < 40; ++i) {
            for (int j = 0; j < 40; ++j) {
                this.hash[i][j] = new ArrayList();
            }
        }
        this.hashWidth = 40;
        this.hashHeight = 40;
    }

    private void hashLocations() {
        int a;
        for (a = 0; a < this.hashWidth; ++a) {
            for (int b = 0; b < this.hashHeight; ++b) {
                this.hash[a][b].clear();
            }
        }
        for (a = 0; a < this.liquid.length; ++a) {
            int hcell = this.hashX(this.liquid[a].m_sweep.c.x);
            int vcell = this.hashY(this.liquid[a].m_sweep.c.y);
            if (hcell <= -1 || hcell >= this.hashWidth || vcell <= -1 || vcell >= this.hashHeight) continue;
            this.hash[hcell][vcell].add(new Integer(a));
        }
    }

    private void applyLiquidConstraint(float deltaT) {
        int i;
        float idealRad = 50.0f;
        float multiplier = 50.0f / this.rad;
        float[] xchange = new float[this.liquid.length];
        float[] ychange = new float[this.liquid.length];
        Arrays.fill(xchange, 0.0f);
        Arrays.fill(ychange, 0.0f);
        float[] xs = new float[this.liquid.length];
        float[] ys = new float[this.liquid.length];
        float[] vxs = new float[this.liquid.length];
        float[] vys = new float[this.liquid.length];
        for (i = 0; i < this.liquid.length; ++i) {
            xs[i] = multiplier * this.liquid[i].m_sweep.c.x;
            ys[i] = multiplier * this.liquid[i].m_sweep.c.y;
            vxs[i] = multiplier * this.liquid[i].m_linearVelocity.x;
            vys[i] = multiplier * this.liquid[i].m_linearVelocity.y;
        }
        i = 0;
        while (i < this.liquid.length) {
            ArrayList<Integer> neighbors = new ArrayList<Integer>();
            int hcell = this.hashX(this.liquid[i].m_sweep.c.x);
            int vcell = this.hashY(this.liquid[i].m_sweep.c.y);
            for (int nx = -1; nx < 2; ++nx) {
                for (int ny = -1; ny < 2; ++ny) {
                    int xc = hcell + nx;
                    int yc = vcell + ny;
                    if (xc <= -1 || xc >= this.hashWidth || yc <= -1 || yc >= this.hashHeight || this.hash[xc][yc].size() <= 0) continue;
                    for (int a = 0; a < this.hash[xc][yc].size(); ++a) {
                        Integer ne = this.hash[xc][yc].get(a);
                        if (ne == null || ne == i) continue;
                        neighbors.add(ne);
                    }
                }
            }
            float[] vlen = new float[neighbors.size()];
            float p = 0.0f;
            float pnear = 0.0f;
            for (int a = 0; a < neighbors.size(); ++a) {
                Integer n = (Integer)neighbors.get(a);
                int j = n;
                float vx = xs[j] - xs[i];
                float vy = ys[j] - ys[i];
                if (!(vx > -50.0f) || !(vx < 50.0f) || !(vy > -50.0f) || !(vy < 50.0f)) continue;
                float vlensqr = vx * vx + vy * vy;
                if (vlensqr < 2500.0f) {
                    vlen[a] = (float)Math.sqrt(vlensqr);
                    if (vlen[a] < 1.1920929E-7f) {
                        vlen[a] = 49.99f;
                    }
                    float oneminusq = 1.0f - vlen[a] / 50.0f;
                    p += oneminusq * oneminusq;
                    pnear += oneminusq * oneminusq * oneminusq;
                    continue;
                }
                vlen[a] = Float.MAX_VALUE;
            }
            float pressure = (p - 5.0f) / 2.0f;
            float presnear = pnear / 2.0f;
            float changex = 0.0f;
            float changey = 0.0f;
            for (int a = 0; a < neighbors.size(); ++a) {
                Integer n = (Integer)neighbors.get(a);
                int j = n;
                float vx = xs[j] - xs[i];
                float vy = ys[j] - ys[i];
                if (!(vx > -50.0f) || !(vx < 50.0f) || !(vy > -50.0f) || !(vy < 50.0f) || !(vlen[a] < 50.0f)) continue;
                float q = vlen[a] / 50.0f;
                float oneminusq = 1.0f - q;
                float factor = oneminusq * (pressure + presnear * oneminusq) / (2.0f * vlen[a]);
                float dx = vx * factor;
                float dy = vy * factor;
                float relvx = vxs[j] - vxs[i];
                float relvy = vys[j] - vys[i];
                factor = this.visc * oneminusq * deltaT;
                int n2 = j;
                xchange[n2] = xchange[n2] + (dx -= relvx * factor);
                int n3 = j;
                ychange[n3] = ychange[n3] + (dy -= relvy * factor);
                changex -= dx;
                changey -= dy;
            }
            int n = i;
            xchange[n] = xchange[n] + changex;
            int n4 = i++;
            ychange[n4] = ychange[n4] + changey;
        }
        for (i = 0; i < this.liquid.length; ++i) {
            this.liquid[i].m_xf.p.x += xchange[i] / multiplier;
            this.liquid[i].m_xf.p.y += ychange[i] / multiplier;
            this.liquid[i].m_linearVelocity.x += xchange[i] / (multiplier * deltaT);
            this.liquid[i].m_linearVelocity.y += ychange[i] / (multiplier * deltaT);
        }
    }

    @Override
    public void initTest(boolean argDeserialized) {
        if (this.firstTime) {
            this.setCamera(new Vec2(0.0f, 2.0f), 35.0f);
            this.firstTime = false;
        }
        Body ground = null;
        BodyDef bd = new BodyDef();
        bd.position.set(0.0f, 0.0f);
        ground = this.getWorld().createBody(bd);
        PolygonShape shape = new PolygonShape();
        shape.setAsBox(5.0f, 0.5f);
        ground.createFixture(shape, 0.0f);
        shape.setAsBox(1.0f, 0.2f, new Vec2(0.0f, 4.0f), -0.2f);
        ground.createFixture(shape, 0.0f);
        shape.setAsBox(1.5f, 0.2f, new Vec2(-1.2f, 5.2f), -1.5f);
        ground.createFixture(shape, 0.0f);
        shape.setAsBox(0.5f, 50.0f, new Vec2(5.0f, 0.0f), 0.0f);
        ground.createFixture(shape, 0.0f);
        shape.setAsBox(0.5f, 3.0f, new Vec2(-8.0f, 0.0f), 0.0f);
        ground.createFixture(shape, 0.0f);
        shape.setAsBox(2.0f, 0.1f, new Vec2(-6.0f, -2.8f), 0.1f);
        ground.createFixture(shape, 0.0f);
        CircleShape cd = new CircleShape();
        cd.m_radius = 0.5f;
        cd.m_p.set(-0.5f, -4.0f);
        ground.createFixture(cd, 0.0f);
        this.liquid = new Body[this.nParticles];
        float massPerParticle = this.totalMass / (float)this.nParticles;
        CircleShape pd = new CircleShape();
        FixtureDef fd = new FixtureDef();
        fd.shape = pd;
        fd.density = 1.0f;
        fd.filter.groupIndex = -10;
        pd.m_radius = 0.05f;
        fd.restitution = 0.4f;
        fd.friction = 0.0f;
        float cx = 0.0f;
        float cy = 25.0f;
        for (int i = 0; i < this.nParticles; ++i) {
            BodyDef bd2 = new BodyDef();
            bd2.position = new Vec2(MathUtils.randomFloat(cx - this.boxWidth * 0.5f, cx + this.boxWidth * 0.5f), MathUtils.randomFloat(cy - this.boxHeight * 0.5f, cy + this.boxHeight * 0.5f));
            bd2.fixedRotation = true;
            bd2.type = BodyType.DYNAMIC;
            Body b = this.getWorld().createBody(bd2);
            b.createFixture(fd).setUserData(LIQUID_INT);
            MassData md = new MassData();
            md.mass = massPerParticle;
            md.I = 1.0f;
            b.setMassData(md);
            b.setSleepingAllowed(false);
            this.liquid[i] = b;
        }
        PolygonShape polyDef = new PolygonShape();
        polyDef.setAsBox(MathUtils.randomFloat(0.3f, 0.7f), MathUtils.randomFloat(0.3f, 0.7f));
        BodyDef bodyDef = new BodyDef();
        bodyDef.position = new Vec2(0.0f, 25.0f);
        bodyDef.type = BodyType.DYNAMIC;
        this.bod = this.getWorld().createBody(bodyDef);
        this.bod.createFixture(polyDef, 1.0f);
    }

    @Override
    public void step(TestbedSettings settings) {
        super.step(settings);
        float hz = settings.getSetting((String)"Hz").value;
        float dt = 1.0f / hz;
        int n = 1;
        for (int i = 0; i < n; ++i) {
            this.hashLocations();
            this.applyLiquidConstraint(dt * (float)n);
        }
        this.dampenLiquid();
        this.checkBounds();
    }

    private void checkBounds() {
        for (int i = 0; i < this.liquid.length; ++i) {
            if (!(this.liquid[i].getWorldCenter().y < -10.0f)) continue;
            this.getWorld().destroyBody(this.liquid[i]);
            float massPerParticle = this.totalMass / (float)this.nParticles;
            CircleShape pd = new CircleShape();
            FixtureDef fd = new FixtureDef();
            fd.shape = pd;
            fd.density = 1.0f;
            fd.filter.groupIndex = -10;
            pd.m_radius = 0.05f;
            fd.restitution = 0.4f;
            fd.friction = 0.0f;
            float cx = 0.0f + MathUtils.randomFloat(-0.6f, 0.6f);
            float cy = 15.0f + MathUtils.randomFloat(-2.3f, 2.0f);
            BodyDef bd = new BodyDef();
            bd.position = new Vec2(cx, cy);
            bd.fixedRotation = true;
            bd.type = BodyType.DYNAMIC;
            Body b = this.getWorld().createBody(bd);
            b.createFixture(fd).setUserData(LIQUID_INT);
            MassData md = new MassData();
            md.mass = massPerParticle;
            md.I = 1.0f;
            b.setMassData(md);
            b.setSleepingAllowed(false);
            this.liquid[i] = b;
        }
        if (this.bod.getWorldCenter().y < -15.0f) {
            this.getWorld().destroyBody(this.bod);
            PolygonShape polyDef = new PolygonShape();
            polyDef.setAsBox(MathUtils.randomFloat(0.3f, 0.7f), MathUtils.randomFloat(0.3f, 0.7f));
            BodyDef bodyDef = new BodyDef();
            bodyDef.position = new Vec2(0.0f, 25.0f);
            bodyDef.type = BodyType.DYNAMIC;
            this.bod = this.getWorld().createBody(bodyDef);
            this.bod.createFixture(polyDef, 1.0f);
        }
    }

    private void dampenLiquid() {
        for (int i = 0; i < this.liquid.length; ++i) {
            Body b = this.liquid[i];
            b.setLinearVelocity(b.getLinearVelocity().mul(0.995f));
        }
    }

    @Override
    public String getTestName() {
        return "Liquid Test";
    }
}

