/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.EdgeShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class VerticalStack
extends TestbedTest {
    private static final long BULLET_TAG = 1L;
    public static final int e_columnCount = 5;
    public static final int e_rowCount = 10;
    Body m_bullet;

    @Override
    public Long getTag(Body argBody) {
        if (argBody == this.m_bullet) {
            return 1L;
        }
        return super.getTag(argBody);
    }

    @Override
    public void processBody(Body argBody, Long argTag) {
        if (argTag == 1L) {
            this.m_bullet = argBody;
            return;
        }
        super.processBody(argBody, argTag);
    }

    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }

    @Override
    public void initTest(boolean argDeserialized) {
        if (argDeserialized) {
            return;
        }
        BodyDef bd = new BodyDef();
        Body ground = this.getWorld().createBody(bd);
        Shape shape = new EdgeShape();
        ((EdgeShape)shape).set(new Vec2(-40.0f, 0.0f), new Vec2(40.0f, 0.0f));
        ground.createFixture(shape, 0.0f);
        ((EdgeShape)shape).set(new Vec2(20.0f, 0.0f), new Vec2(20.0f, 20.0f));
        ground.createFixture(shape, 0.0f);
        float[] xs = new float[]{0.0f, -10.0f, -5.0f, 5.0f, 10.0f};
        for (int j = 0; j < 5; ++j) {
            shape = new PolygonShape();
            ((PolygonShape)shape).setAsBox(0.5f, 0.5f);
            FixtureDef fd = new FixtureDef();
            fd.shape = shape;
            fd.density = 1.0f;
            fd.friction = 0.3f;
            for (int i = 0; i < 10; ++i) {
                BodyDef bd2 = new BodyDef();
                bd2.type = BodyType.DYNAMIC;
                int n = j * 10 + i;
                assert (n < 50);
                float x = 0.0f;
                bd2.position.set(xs[j] + x, 0.752f + 1.54f * (float)i);
                Body body = this.getWorld().createBody(bd2);
                body.createFixture(fd);
            }
        }
        this.m_bullet = null;
    }

    @Override
    public void keyPressed(char argKeyChar, int argKeyCode) {
        switch (argKeyChar) {
            case ',': {
                if (this.m_bullet != null) {
                    this.getWorld().destroyBody(this.m_bullet);
                    this.m_bullet = null;
                }
                CircleShape shape = new CircleShape();
                shape.m_radius = 0.25f;
                FixtureDef fd = new FixtureDef();
                fd.shape = shape;
                fd.density = 20.0f;
                fd.restitution = 0.05f;
                BodyDef bd = new BodyDef();
                bd.type = BodyType.DYNAMIC;
                bd.bullet = true;
                bd.position.set(-31.0f, 5.0f);
                this.m_bullet = this.getWorld().createBody(bd);
                this.m_bullet.createFixture(fd);
                this.m_bullet.setLinearVelocity(new Vec2(400.0f, 0.0f));
            }
        }
    }

    @Override
    public void step(TestbedSettings settings) {
        super.step(settings);
        this.addTextLine("Press ',' to launch bullet.");
    }

    @Override
    public String getTestName() {
        return "Vertical Stack";
    }
}

