/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision.broadphase;

import org.jbox2d.callbacks.DebugDraw;
import org.jbox2d.callbacks.TreeCallback;
import org.jbox2d.callbacks.TreeRayCastCallback;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.RayCastInput;
import org.jbox2d.collision.broadphase.TreeNode;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.pooling.stacks.DynamicIntStack;

public class DynamicTree {
    public static final int MAX_STACK_SIZE = 64;
    private int m_root = -1;
    private TreeNode[] m_nodes;
    private int m_nodeCount = 0;
    private int m_nodeCapacity = 16;
    private int m_freeList;
    private int m_insertionCount;
    private final Vec2[] drawVecs = new Vec2[4];
    private final DynamicIntStack intStack = new DynamicIntStack(10);
    private final Vec2 r = new Vec2();
    private final Vec2 v = new Vec2();
    private final Vec2 absV = new Vec2();
    private final Vec2 temp = new Vec2();
    private final Vec2 c = new Vec2();
    private final Vec2 h = new Vec2();
    private final Vec2 t = new Vec2();
    private final AABB aabb = new AABB();
    private final RayCastInput subInput = new RayCastInput();
    private final AABB combinedAABB = new AABB();
    private final Color3f color = new Color3f();
    private final Vec2 textVec = new Vec2();

    public DynamicTree() {
        this.m_nodes = new TreeNode[16];
        int i = 0;
        while (i < this.m_nodeCapacity) {
            this.m_nodes[i] = new TreeNode();
            this.m_nodes[i].parent = i + 1;
            this.m_nodes[i].height = -1;
            ++i;
        }
        this.m_nodes[this.m_nodeCapacity - 1].parent = -1;
        this.m_freeList = 0;
        this.m_insertionCount = 0;
        i = 0;
        while (i < this.drawVecs.length) {
            this.drawVecs[i] = new Vec2();
            ++i;
        }
    }

    public final int createProxy(AABB aabb, Object userData) {
        int proxyId = this.allocateNode();
        TreeNode node = this.m_nodes[proxyId];
        node.aabb.lowerBound.x = aabb.lowerBound.x - 0.1f;
        node.aabb.lowerBound.y = aabb.lowerBound.y - 0.1f;
        node.aabb.upperBound.x = aabb.upperBound.x + 0.1f;
        node.aabb.upperBound.y = aabb.upperBound.y + 0.1f;
        node.userData = userData;
        this.insertLeaf(proxyId);
        return proxyId;
    }

    public final void destroyProxy(int proxyId) {
        assert (proxyId >= 0 && proxyId < this.m_nodeCapacity);
        assert (this.m_nodes[proxyId].isLeaf());
        this.removeLeaf(proxyId);
        this.freeNode(proxyId);
    }

    public final boolean moveProxy(int proxyId, AABB aabb, Vec2 displacement) {
        assert (proxyId >= 0 && proxyId < this.m_nodeCapacity);
        TreeNode node = this.m_nodes[proxyId];
        assert (node.isLeaf());
        if (node.aabb.contains(aabb)) {
            return false;
        }
        this.removeLeaf(proxyId);
        Vec2 lowerBound = aabb.lowerBound;
        Vec2 upperBound = aabb.upperBound;
        lowerBound.x -= 0.1f;
        lowerBound.y -= 0.1f;
        upperBound.x += 0.1f;
        upperBound.y += 0.1f;
        float dx = displacement.x * 2.0f;
        float dy = displacement.y * 2.0f;
        if (dx < 0.0f) {
            lowerBound.x += dx;
        } else {
            upperBound.x += dx;
        }
        if (dy < 0.0f) {
            lowerBound.y += dy;
        } else {
            upperBound.y += dy;
        }
        node.aabb.lowerBound.x = lowerBound.x;
        node.aabb.lowerBound.y = lowerBound.y;
        node.aabb.upperBound.x = upperBound.x;
        node.aabb.upperBound.y = upperBound.y;
        this.insertLeaf(proxyId);
        return true;
    }

    public final Object getUserData(int proxyId) {
        assert (proxyId >= 0 && proxyId < this.m_nodeCapacity);
        return this.m_nodes[proxyId].userData;
    }

    public final AABB getFatAABB(int proxyId) {
        assert (proxyId >= 0 && proxyId < this.m_nodeCapacity);
        return this.m_nodes[proxyId].aabb;
    }

    public final void query(TreeCallback callback, AABB aabb) {
        this.intStack.reset();
        this.intStack.push(this.m_root);
        while (this.intStack.getCount() > 0) {
            int nodeId = this.intStack.pop();
            if (nodeId == -1) continue;
            TreeNode node = this.m_nodes[nodeId];
            if (!AABB.testOverlap(node.aabb, aabb)) continue;
            if (node.isLeaf()) {
                boolean proceed = callback.treeCallback(nodeId);
                if (proceed) continue;
                return;
            }
            this.intStack.push(node.child1);
            this.intStack.push(node.child2);
        }
    }

    public void raycast(TreeRayCastCallback callback, RayCastInput input) {
        Vec2 p1 = input.p1;
        Vec2 p2 = input.p2;
        this.r.set(p2).subLocal(p1);
        assert (this.r.lengthSquared() > 0.0f);
        this.r.normalize();
        Vec2.crossToOutUnsafe(1.0f, this.r, this.v);
        this.absV.set(this.v).absLocal();
        float maxFraction = input.maxFraction;
        AABB segAABB = this.aabb;
        this.temp.set(p2).subLocal(p1).mulLocal(maxFraction).addLocal(p1);
        Vec2.minToOut(p1, this.temp, segAABB.lowerBound);
        Vec2.maxToOut(p1, this.temp, segAABB.upperBound);
        this.intStack.push(this.m_root);
        while (this.intStack.getCount() > 0) {
            int nodeId = this.intStack.pop();
            if (nodeId == -1) continue;
            TreeNode node = this.m_nodes[nodeId];
            if (!AABB.testOverlap(node.aabb, segAABB)) continue;
            node.aabb.getCenterToOut(this.c);
            node.aabb.getExtentsToOut(this.h);
            this.temp.set(p1).subLocal(this.c);
            float separation = MathUtils.abs(Vec2.dot(this.v, this.temp)) - Vec2.dot(this.absV, this.h);
            if (separation > 0.0f) continue;
            if (node.isLeaf()) {
                this.subInput.p1.set(input.p1);
                this.subInput.p2.set(input.p2);
                this.subInput.maxFraction = maxFraction;
                float value = callback.raycastCallback(this.subInput, nodeId);
                if (value == 0.0f) {
                    return;
                }
                if (!(value > 0.0f)) continue;
                maxFraction = value;
                this.t.set(p2).subLocal(p1).mulLocal(maxFraction).addLocal(p1);
                Vec2.minToOut(p1, this.t, segAABB.lowerBound);
                Vec2.maxToOut(p1, this.t, segAABB.upperBound);
                continue;
            }
            this.intStack.push(node.child1);
            this.intStack.push(node.child2);
        }
    }

    public final int computeHeight() {
        return this.computeHeight(this.m_root);
    }

    private final int computeHeight(int nodeId) {
        assert (nodeId >= 0 && nodeId < this.m_nodeCapacity);
        TreeNode node = this.m_nodes[nodeId];
        if (node.isLeaf()) {
            return 0;
        }
        int height1 = this.computeHeight(node.child1);
        int height2 = this.computeHeight(node.child2);
        return 1 + MathUtils.max(height1, height2);
    }

    public void validate() {
        this.validateStructure(this.m_root);
        this.validateMetrics(this.m_root);
        int freeCount = 0;
        int freeIndex = this.m_freeList;
        while (freeIndex != -1) {
            assert (freeIndex >= 0 && freeIndex < this.m_nodeCapacity);
            freeIndex = this.m_nodes[freeIndex].parent;
            ++freeCount;
        }
        assert (this.getHeight() == this.computeHeight());
        assert (this.m_nodeCount + freeCount == this.m_nodeCapacity);
    }

    public int getHeight() {
        if (this.m_root == -1) {
            return 0;
        }
        return this.m_nodes[this.m_root].height;
    }

    public int getMaxBalance() {
        int maxBalance = 0;
        int i = 0;
        while (i < this.m_nodeCapacity) {
            TreeNode node = this.m_nodes[i];
            if (node.height > 1) {
                assert (!node.isLeaf());
                int child1 = node.child1;
                int child2 = node.child2;
                int balance = MathUtils.abs(this.m_nodes[child2].height - this.m_nodes[child1].height);
                maxBalance = MathUtils.max(maxBalance, balance);
            }
            ++i;
        }
        return maxBalance;
    }

    public float getAreaRatio() {
        if (this.m_root == -1) {
            return 0.0f;
        }
        TreeNode root = this.m_nodes[this.m_root];
        float rootArea = root.aabb.getPerimeter();
        float totalArea = 0.0f;
        int i = 0;
        while (i < this.m_nodeCapacity) {
            TreeNode node = this.m_nodes[i];
            if (node.height >= 0) {
                totalArea += node.aabb.getPerimeter();
            }
            ++i;
        }
        return totalArea / rootArea;
    }

    public void rebuildBottomUp() {
        int[] nodes = new int[this.m_nodeCount];
        int count = 0;
        int i = 0;
        while (i < this.m_nodeCapacity) {
            if (this.m_nodes[i].height >= 0) {
                if (this.m_nodes[i].isLeaf()) {
                    this.m_nodes[i].parent = -1;
                    nodes[count] = i;
                    ++count;
                } else {
                    this.freeNode(i);
                }
            }
            ++i;
        }
        AABB b = new AABB();
        while (count > 1) {
            float minCost = Float.MAX_VALUE;
            int iMin = -1;
            int jMin = -1;
            int i2 = 0;
            while (i2 < count) {
                AABB aabbi = this.m_nodes[nodes[i2]].aabb;
                int j = i2 + 1;
                while (j < count) {
                    AABB aabbj = this.m_nodes[nodes[j]].aabb;
                    b.combine(aabbi, aabbj);
                    float cost = b.getPerimeter();
                    if (cost < minCost) {
                        iMin = i2;
                        jMin = j;
                        minCost = cost;
                    }
                    ++j;
                }
                ++i2;
            }
            int index1 = nodes[iMin];
            int index2 = nodes[jMin];
            TreeNode child1 = this.m_nodes[index1];
            TreeNode child2 = this.m_nodes[index2];
            int parentIndex = this.allocateNode();
            TreeNode parent = this.m_nodes[parentIndex];
            parent.child1 = index1;
            parent.child2 = index2;
            parent.height = 1 + MathUtils.max(child1.height, child2.height);
            parent.aabb.combine(child1.aabb, child2.aabb);
            parent.parent = -1;
            child1.parent = parentIndex;
            child2.parent = parentIndex;
            nodes[jMin] = nodes[count - 1];
            nodes[iMin] = parentIndex;
            --count;
        }
        this.m_root = nodes[0];
        this.validate();
    }

    private final int allocateNode() {
        if (this.m_freeList == -1) {
            assert (this.m_nodeCount == this.m_nodeCapacity);
            TreeNode[] old = this.m_nodes;
            this.m_nodeCapacity *= 2;
            this.m_nodes = new TreeNode[this.m_nodeCapacity];
            System.arraycopy(old, 0, this.m_nodes, 0, old.length);
            int i = this.m_nodeCount;
            while (i < this.m_nodeCapacity) {
                this.m_nodes[i] = new TreeNode();
                this.m_nodes[i].parent = i + 1;
                this.m_nodes[i].height = -1;
                ++i;
            }
            this.m_nodes[this.m_nodeCapacity - 1].parent = -1;
            this.m_freeList = this.m_nodeCount;
        }
        int nodeId = this.m_freeList;
        this.m_freeList = this.m_nodes[nodeId].parent;
        this.m_nodes[nodeId].parent = -1;
        this.m_nodes[nodeId].child1 = -1;
        this.m_nodes[nodeId].child2 = -1;
        this.m_nodes[nodeId].height = 0;
        this.m_nodes[nodeId].userData = null;
        ++this.m_nodeCount;
        return nodeId;
    }

    private final void freeNode(int nodeId) {
        assert (nodeId != -1);
        assert (this.m_nodeCount > 0);
        this.m_nodes[nodeId].parent = this.m_freeList;
        this.m_nodes[nodeId].height = -1;
        this.m_freeList = nodeId;
        --this.m_nodeCount;
    }

    public int getInsertionCount() {
        return this.m_insertionCount;
    }

    private final void insertLeaf(int leaf) {
        ++this.m_insertionCount;
        if (this.m_root == -1) {
            this.m_root = leaf;
            this.m_nodes[this.m_root].parent = -1;
            return;
        }
        AABB leafAABB = this.m_nodes[leaf].aabb;
        int index = this.m_root;
        while (!this.m_nodes[index].isLeaf()) {
            float cost2;
            float cost1;
            TreeNode node = this.m_nodes[index];
            int child1 = node.child1;
            int child2 = node.child2;
            float area = node.aabb.getPerimeter();
            this.combinedAABB.combine(node.aabb, leafAABB);
            float combinedArea = this.combinedAABB.getPerimeter();
            float cost = 2.0f * combinedArea;
            float inheritanceCost = 2.0f * (combinedArea - area);
            if (this.m_nodes[child1].isLeaf()) {
                this.combinedAABB.combine(leafAABB, this.m_nodes[child1].aabb);
                cost1 = this.combinedAABB.getPerimeter() + inheritanceCost;
            } else {
                this.combinedAABB.combine(leafAABB, this.m_nodes[child1].aabb);
                float oldArea = this.m_nodes[child1].aabb.getPerimeter();
                float newArea = this.combinedAABB.getPerimeter();
                cost1 = newArea - oldArea + inheritanceCost;
            }
            if (this.m_nodes[child2].isLeaf()) {
                this.combinedAABB.combine(leafAABB, this.m_nodes[child2].aabb);
                cost2 = this.combinedAABB.getPerimeter() + inheritanceCost;
            } else {
                this.combinedAABB.combine(leafAABB, this.m_nodes[child2].aabb);
                float oldArea = this.m_nodes[child2].aabb.getPerimeter();
                float newArea = this.combinedAABB.getPerimeter();
                cost2 = newArea - oldArea + inheritanceCost;
            }
            if (cost < cost1 && cost < cost2) break;
            index = cost1 < cost2 ? child1 : child2;
        }
        int sibling = index;
        int oldParent = this.m_nodes[sibling].parent;
        int newParentId = this.allocateNode();
        TreeNode newParent = this.m_nodes[newParentId];
        newParent.parent = oldParent;
        newParent.userData = null;
        newParent.aabb.combine(leafAABB, this.m_nodes[sibling].aabb);
        newParent.height = this.m_nodes[sibling].height + 1;
        if (oldParent != -1) {
            if (this.m_nodes[oldParent].child1 == sibling) {
                this.m_nodes[oldParent].child1 = newParentId;
            } else {
                this.m_nodes[oldParent].child2 = newParentId;
            }
            this.m_nodes[newParentId].child1 = sibling;
            this.m_nodes[newParentId].child2 = leaf;
            this.m_nodes[sibling].parent = newParentId;
            this.m_nodes[leaf].parent = newParentId;
        } else {
            this.m_nodes[newParentId].child1 = sibling;
            this.m_nodes[newParentId].child2 = leaf;
            this.m_nodes[sibling].parent = newParentId;
            this.m_nodes[leaf].parent = newParentId;
            this.m_root = newParentId;
        }
        index = this.m_nodes[leaf].parent;
        while (index != -1) {
            index = this.balance(index);
            int child1 = this.m_nodes[index].child1;
            int child2 = this.m_nodes[index].child2;
            assert (child1 != -1);
            assert (child2 != -1);
            this.m_nodes[index].height = 1 + MathUtils.max(this.m_nodes[child1].height, this.m_nodes[child2].height);
            this.m_nodes[index].aabb.combine(this.m_nodes[child1].aabb, this.m_nodes[child2].aabb);
            index = this.m_nodes[index].parent;
        }
    }

    private final void removeLeaf(int leaf) {
        if (leaf == this.m_root) {
            this.m_root = -1;
            return;
        }
        int parent = this.m_nodes[leaf].parent;
        int grandParent = this.m_nodes[parent].parent;
        int sibling = this.m_nodes[parent].child1 == leaf ? this.m_nodes[parent].child2 : this.m_nodes[parent].child1;
        if (grandParent != -1) {
            if (this.m_nodes[grandParent].child1 == parent) {
                this.m_nodes[grandParent].child1 = sibling;
            } else {
                this.m_nodes[grandParent].child2 = sibling;
            }
            this.m_nodes[sibling].parent = grandParent;
            this.freeNode(parent);
            int index = grandParent;
            while (index != -1) {
                index = this.balance(index);
                int child1 = this.m_nodes[index].child1;
                int child2 = this.m_nodes[index].child2;
                this.m_nodes[index].aabb.combine(this.m_nodes[child1].aabb, this.m_nodes[child2].aabb);
                this.m_nodes[index].height = 1 + MathUtils.max(this.m_nodes[child1].height, this.m_nodes[child2].height);
                index = this.m_nodes[index].parent;
            }
        } else {
            this.m_root = sibling;
            this.m_nodes[sibling].parent = -1;
            this.freeNode(parent);
        }
    }

    private int balance(int iA) {
        assert (iA != -1);
        TreeNode A = this.m_nodes[iA];
        if (A.isLeaf() || A.height < 2) {
            return iA;
        }
        int iB = A.child1;
        int iC = A.child2;
        assert (iB >= 0 && iB < this.m_nodeCapacity);
        assert (iC >= 0 && iC < this.m_nodeCapacity);
        TreeNode B = this.m_nodes[iB];
        TreeNode C = this.m_nodes[iC];
        int balance = C.height - B.height;
        if (balance > 1) {
            int iF = C.child1;
            int iG = C.child2;
            TreeNode F = this.m_nodes[iF];
            TreeNode G = this.m_nodes[iG];
            assert (iF >= 0 && iF < this.m_nodeCapacity);
            assert (iG >= 0 && iG < this.m_nodeCapacity);
            C.child1 = iA;
            C.parent = A.parent;
            A.parent = iC;
            if (C.parent != -1) {
                if (this.m_nodes[C.parent].child1 == iA) {
                    this.m_nodes[C.parent].child1 = iC;
                } else {
                    assert (this.m_nodes[C.parent].child2 == iA);
                    this.m_nodes[C.parent].child2 = iC;
                }
            } else {
                this.m_root = iC;
            }
            if (F.height > G.height) {
                C.child2 = iF;
                A.child2 = iG;
                G.parent = iA;
                A.aabb.combine(B.aabb, G.aabb);
                C.aabb.combine(A.aabb, F.aabb);
                A.height = 1 + MathUtils.max(B.height, G.height);
                C.height = 1 + MathUtils.max(A.height, F.height);
            } else {
                C.child2 = iG;
                A.child2 = iF;
                F.parent = iA;
                A.aabb.combine(B.aabb, F.aabb);
                C.aabb.combine(A.aabb, G.aabb);
                A.height = 1 + MathUtils.max(B.height, F.height);
                C.height = 1 + MathUtils.max(A.height, G.height);
            }
            return iC;
        }
        if (balance < -1) {
            int iD = B.child1;
            int iE = B.child2;
            TreeNode D = this.m_nodes[iD];
            TreeNode E = this.m_nodes[iE];
            assert (iD >= 0 && iD < this.m_nodeCapacity);
            assert (iE >= 0 && iE < this.m_nodeCapacity);
            B.child1 = iA;
            B.parent = A.parent;
            A.parent = iB;
            if (B.parent != -1) {
                if (this.m_nodes[B.parent].child1 == iA) {
                    this.m_nodes[B.parent].child1 = iB;
                } else {
                    assert (this.m_nodes[B.parent].child2 == iA);
                    this.m_nodes[B.parent].child2 = iB;
                }
            } else {
                this.m_root = iB;
            }
            if (D.height > E.height) {
                B.child2 = iD;
                A.child1 = iE;
                E.parent = iA;
                A.aabb.combine(C.aabb, E.aabb);
                B.aabb.combine(A.aabb, D.aabb);
                A.height = 1 + MathUtils.max(C.height, E.height);
                B.height = 1 + MathUtils.max(A.height, D.height);
            } else {
                B.child2 = iE;
                A.child1 = iD;
                D.parent = iA;
                A.aabb.combine(C.aabb, D.aabb);
                B.aabb.combine(A.aabb, E.aabb);
                A.height = 1 + MathUtils.max(C.height, D.height);
                B.height = 1 + MathUtils.max(A.height, E.height);
            }
            return iB;
        }
        return iA;
    }

    private void validateStructure(int index) {
        if (index == -1) {
            return;
        }
        if (index == this.m_root) assert (this.m_nodes[index].parent == -1);
        TreeNode node = this.m_nodes[index];
        int child1 = node.child1;
        int child2 = node.child2;
        if (node.isLeaf()) {
            assert (child1 == -1);
            assert (child2 == -1);
            assert (node.height == 0);
            return;
        }
        assert (child1 >= 0 && child1 < this.m_nodeCapacity);
        assert (child2 >= 0 && child2 < this.m_nodeCapacity);
        assert (this.m_nodes[child1].parent == index);
        assert (this.m_nodes[child2].parent == index);
        this.validateStructure(child1);
        this.validateStructure(child2);
    }

    private void validateMetrics(int index) {
        if (index == -1) {
            return;
        }
        TreeNode node = this.m_nodes[index];
        int child1 = node.child1;
        int child2 = node.child2;
        if (node.isLeaf()) {
            assert (child1 == -1);
            assert (child2 == -1);
            assert (node.height == 0);
            return;
        }
        assert (child1 >= 0 && child1 < this.m_nodeCapacity);
        assert (child2 >= 0 && child2 < this.m_nodeCapacity);
        int height1 = this.m_nodes[child1].height;
        int height2 = this.m_nodes[child2].height;
        int height = 1 + MathUtils.max(height1, height2);
        assert (node.height == height);
        AABB aabb = new AABB();
        aabb.combine(this.m_nodes[child1].aabb, this.m_nodes[child2].aabb);
        assert (aabb.lowerBound.equals(node.aabb.lowerBound));
        assert (aabb.upperBound.equals(node.aabb.upperBound));
        this.validateMetrics(child1);
        this.validateMetrics(child2);
    }

    public void drawTree(DebugDraw argDraw) {
        if (this.m_root == -1) {
            return;
        }
        int height = this.computeHeight();
        this.drawTree(argDraw, this.m_root, 0, height);
    }

    public void drawTree(DebugDraw argDraw, int nodeId, int spot, int height) {
        TreeNode node = this.m_nodes[nodeId];
        node.aabb.getVertices(this.drawVecs);
        this.color.set(1.0f, (float)(height - spot) * 1.0f / (float)height, (float)(height - spot) * 1.0f / (float)height);
        argDraw.drawPolygon(this.drawVecs, 4, this.color);
        argDraw.getViewportTranform().getWorldToScreen(node.aabb.upperBound, this.textVec);
        argDraw.drawString(this.textVec.x, this.textVec.y, String.valueOf(nodeId) + "-" + (spot + 1) + "/" + height, this.color);
        if (node.child1 != -1) {
            this.drawTree(argDraw, node.child1, spot + 1, height);
        }
        if (node.child2 != -1) {
            this.drawTree(argDraw, node.child2, spot + 1, height);
        }
    }
}

