/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharacterCollisionProblem
extends TestbedTest {
    private static final Logger log = LoggerFactory.getLogger(CharacterCollisionProblem.class);

    @Override
    public void initTest(boolean argDeserialized) {
        BodyDef bd = new BodyDef();
        bd.position = new Vec2(1.0f, 0.0f);
        Body ground = this.getWorld().createBody(bd);
        PolygonShape shape = new PolygonShape();
        Vec2[] vertices = new Vec2[]{new Vec2(0.0f, -5.3f), new Vec2(0.033333335f, -5.3333335f), new Vec2(9.633333f, -5.3333335f), new Vec2(9.666667f, -5.3f), new Vec2(9.666667f, -4.7000003f), new Vec2(9.633333f, -4.666667f), new Vec2(0.033333335f, -4.666667f), new Vec2(0.0f, -4.7000003f)};
        shape.set(vertices, 8);
        ground.createFixture(shape, 1.0f);
        bd = new BodyDef();
        bd.position.set(4.0f, 5.0f);
        bd.type = BodyType.DYNAMIC;
        bd.fixedRotation = true;
        bd.allowSleep = false;
        Body body = this.getWorld().createBody(bd);
        shape = new PolygonShape();
        shape.setAsBox(0.2f, 0.8f);
        FixtureDef fd = new FixtureDef();
        fd.shape = shape;
        fd.density = 20.0f;
        body.createFixture(fd);
        bd = new BodyDef();
        bd.position.set(6.0f, 5.0f);
        bd.type = BodyType.DYNAMIC;
        bd.fixedRotation = true;
        bd.allowSleep = false;
        body = this.getWorld().createBody(bd);
        shape = new PolygonShape();
        shape.setAsBox(0.2f, 0.8f);
        fd = new FixtureDef();
        fd.shape = shape;
        fd.density = 20.0f;
        body.createFixture(fd);
    }

    @Override
    public void step(TestbedSettings settings) {
        super.step(settings);
        this.addTextLine("Test that illustrates a collision problem.");
    }

    @Override
    public String getTestName() {
        return "Collision Problem";
    }

    @Override
    public boolean isSaveLoadEnabled() {
        return true;
    }
}

