/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.framework.j2d;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.ListCellRenderer;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jbox2d.testbed.framework.TestbedController;
import org.jbox2d.testbed.framework.TestbedModel;
import org.jbox2d.testbed.framework.TestbedSetting;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class TestbedSidePanel
extends JPanel
implements ChangeListener,
ActionListener {
    private static final String SETTING_TAG = "settings";
    private static final String LABEL_TAG = "label";
    final TestbedModel model;
    final TestbedController controller;
    public JComboBox tests;
    private JButton pauseButton = new JButton("Pause");
    private JButton stepButton = new JButton("Step");
    private JButton resetButton = new JButton("Reset");
    private JButton quitButton = new JButton("Quit");
    public JButton saveButton = new JButton("Save");
    public JButton loadButton = new JButton("Load");

    public TestbedSidePanel(TestbedModel argModel, TestbedController argController) {
        this.model = argModel;
        this.controller = argController;
        this.initComponents();
        this.addListeners();
        this.model.addTestChangeListener(new TestbedModel.TestChangedListener(){

            @Override
            public void testChanged(TestbedTest argTest, int argIndex) {
                TestbedSidePanel.this.tests.setSelectedIndex(argIndex);
                TestbedSidePanel.this.saveButton.setEnabled(argTest.isSaveLoadEnabled());
                TestbedSidePanel.this.loadButton.setEnabled(argTest.isSaveLoadEnabled());
            }
        });
    }

    public void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        TestbedSettings settings = this.model.getSettings();
        JPanel top = new JPanel();
        top.setLayout(new GridLayout(0, 1));
        top.setBorder(BorderFactory.createCompoundBorder(new EtchedBorder(1), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.tests = new JComboBox(this.model.getComboModel());
        this.tests.setMaximumRowCount(30);
        this.tests.setMaximumSize(new Dimension(250, 20));
        this.tests.addActionListener(this);
        this.tests.setRenderer(new ListCellRenderer(){
            JLabel categoryLabel = null;
            JLabel testLabel = null;

            public Component getListCellRendererComponent(JList list, Object ovalue, int index, boolean isSelected, boolean cellHasFocus) {
                TestbedModel.ListItem value = (TestbedModel.ListItem)ovalue;
                if (value.isCategory()) {
                    if (this.categoryLabel == null) {
                        this.categoryLabel = new JLabel();
                        this.categoryLabel.setOpaque(true);
                        this.categoryLabel.setBackground(new Color(0.5f, 0.5f, 0.6f));
                        this.categoryLabel.setForeground(Color.white);
                        this.categoryLabel.setHorizontalAlignment(0);
                        this.categoryLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
                    }
                    this.categoryLabel.setText(value.category);
                    return this.categoryLabel;
                }
                if (this.testLabel == null) {
                    this.testLabel = new JLabel();
                    this.testLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 1, 0));
                }
                this.testLabel.setText(value.test.getTestName());
                if (isSelected) {
                    this.testLabel.setBackground(list.getSelectionBackground());
                    this.testLabel.setForeground(list.getSelectionForeground());
                } else {
                    this.testLabel.setBackground(list.getBackground());
                    this.testLabel.setForeground(list.getForeground());
                }
                return this.testLabel;
            }
        });
        top.add(new JLabel("Choose a test:"));
        top.add(this.tests);
        this.addSettings(top, settings, TestbedSetting.SettingType.DRAWING);
        this.add((Component)top, "North");
        JPanel middle = new JPanel();
        middle.setLayout(new GridLayout(0, 1));
        middle.setBorder(BorderFactory.createCompoundBorder(new EtchedBorder(1), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        this.addSettings(middle, settings, TestbedSetting.SettingType.ENGINE);
        this.add((Component)middle, "Center");
        this.pauseButton.setAlignmentX(0.5f);
        this.stepButton.setAlignmentX(0.5f);
        this.resetButton.setAlignmentX(0.5f);
        this.saveButton.setAlignmentX(0.5f);
        this.loadButton.setAlignmentX(0.5f);
        this.quitButton.setAlignmentX(0.5f);
        Box buttonGroups = Box.createHorizontalBox();
        JPanel buttons1 = new JPanel();
        buttons1.setLayout(new GridLayout(0, 1));
        buttons1.add(this.resetButton);
        JPanel buttons2 = new JPanel();
        buttons2.setLayout(new GridLayout(0, 1));
        buttons2.add(this.pauseButton);
        buttons2.add(this.stepButton);
        JPanel buttons3 = new JPanel();
        buttons3.setLayout(new GridLayout(0, 1));
        buttons3.add(this.saveButton);
        buttons3.add(this.loadButton);
        buttons3.add(this.quitButton);
        buttonGroups.add(buttons1);
        buttonGroups.add(buttons2);
        buttonGroups.add(buttons3);
        this.add((Component)buttonGroups, "South");
    }

    public void addListeners() {
        this.pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TestbedSidePanel.this.model.getSettings().pause) {
                    TestbedSidePanel.this.model.getSettings().pause = false;
                    TestbedSidePanel.this.pauseButton.setText("Pause");
                } else {
                    TestbedSidePanel.this.model.getSettings().pause = true;
                    TestbedSidePanel.this.pauseButton.setText("Resume");
                }
            }
        });
        this.stepButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestbedSidePanel.this.model.getSettings().singleStep = true;
                if (!TestbedSidePanel.this.model.getSettings().pause) {
                    TestbedSidePanel.this.model.getSettings().pause = true;
                    TestbedSidePanel.this.pauseButton.setText("Resume");
                }
            }
        });
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestbedSidePanel.this.controller.resetTest();
            }
        });
        this.quitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestbedSidePanel.this.controller.saveTest();
            }
        });
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestbedSidePanel.this.controller.loadTest();
            }
        });
    }

    private void addSettings(JPanel argPanel, TestbedSettings argSettings, TestbedSetting.SettingType argIgnore) {
        for (TestbedSetting setting : argSettings.getSettings()) {
            if (setting.settingsType == argIgnore) continue;
            switch (setting.constraintType) {
                case RANGE: {
                    JLabel text = new JLabel(setting.name + ": " + setting.value);
                    JSlider slider = new JSlider(setting.min, setting.max, setting.value);
                    slider.setMaximumSize(new Dimension(200, 20));
                    slider.addChangeListener(this);
                    slider.setName(setting.name);
                    slider.putClientProperty(SETTING_TAG, setting);
                    slider.putClientProperty(LABEL_TAG, text);
                    argPanel.add(text);
                    argPanel.add(slider);
                    break;
                }
                case BOOLEAN: {
                    JCheckBox checkbox = new JCheckBox(setting.name);
                    checkbox.setSelected(setting.enabled);
                    checkbox.addChangeListener(this);
                    checkbox.putClientProperty(SETTING_TAG, setting);
                    argPanel.add(checkbox);
                }
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JComponent component = (JComponent)e.getSource();
        TestbedSetting setting = (TestbedSetting)component.getClientProperty(SETTING_TAG);
        switch (setting.constraintType) {
            case BOOLEAN: {
                JCheckBox box = (JCheckBox)e.getSource();
                setting.enabled = box.isSelected();
                break;
            }
            case RANGE: {
                JSlider slider = (JSlider)e.getSource();
                setting.value = slider.getValue();
                JLabel label = (JLabel)slider.getClientProperty(LABEL_TAG);
                label.setText(setting.name + ": " + setting.value);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.controller.playTest(this.tests.getSelectedIndex());
    }
}

