/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.contacts;

import org.jbox2d.common.Rot;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.contacts.ContactPositionConstraint;

class PositionSolverManifold {
    public final Vec2 normal = new Vec2();
    public final Vec2 point = new Vec2();
    public float separation;
    private final Vec2 pointA = new Vec2();
    private final Vec2 pointB = new Vec2();
    private final Vec2 temp = new Vec2();
    private final Vec2 planePoint = new Vec2();
    private final Vec2 clipPoint = new Vec2();

    PositionSolverManifold() {
    }

    public void initialize(ContactPositionConstraint pc, Transform xfA, Transform xfB, int index) {
        assert (pc.pointCount > 0);
        switch (pc.type) {
            case CIRCLES: {
                Transform.mulToOutUnsafe(xfA, pc.localPoint, this.pointA);
                Transform.mulToOutUnsafe(xfB, pc.localPoints[0], this.pointB);
                this.normal.set(this.pointB).subLocal(this.pointA);
                this.normal.normalize();
                this.point.set(this.pointA).addLocal(this.pointB).mulLocal(0.5f);
                this.temp.set(this.pointB).subLocal(this.pointA);
                this.separation = Vec2.dot(this.temp, this.normal) - pc.radiusA - pc.radiusB;
                break;
            }
            case FACE_A: {
                Rot.mulToOutUnsafe(xfA.q, pc.localNormal, this.normal);
                Transform.mulToOutUnsafe(xfA, pc.localPoint, this.planePoint);
                Transform.mulToOutUnsafe(xfB, pc.localPoints[index], this.clipPoint);
                this.temp.set(this.clipPoint).subLocal(this.planePoint);
                this.separation = Vec2.dot(this.temp, this.normal) - pc.radiusA - pc.radiusB;
                this.point.set(this.clipPoint);
                break;
            }
            case FACE_B: {
                Rot.mulToOutUnsafe(xfB.q, pc.localNormal, this.normal);
                Transform.mulToOutUnsafe(xfB, pc.localPoint, this.planePoint);
                Transform.mulToOutUnsafe(xfA, pc.localPoints[index], this.clipPoint);
                this.temp.set(this.clipPoint).subLocal(this.planePoint);
                this.separation = Vec2.dot(this.temp, this.normal) - pc.radiusA - pc.radiusB;
                this.point.set(this.clipPoint);
                this.normal.negateLocal();
            }
        }
    }
}

